#include "mode1/erdiagram/Arrow.h"
#include "mode1/erdiagram/Table.h"
#include "mode1/erdiagram/Canvas.h"
#include <math.h>
#include <QGraphicsItem>
#include <QtGui>

#include "mode1/SHtableRelationDlg.h"

/*
#include "mode1/DrawERDlg.h"
#include "mode1/erdiagram/Table.h"
#include "mode1/erdiagram/Arrow.h"
#include "mode1/erdiagram/NameRect.h"
#include "mode1/erdiagram/Name.h"
#include "mode1/erdiagram/PrimaryKeysRect.h"
#include "mode1/erdiagram/AttributesRect.h"
#include "mode1/erdiagram/Canvas.h"
#include "mode1/erdiagram/Attribute.h"
#include "mode1/erdiagram/PrimaryKey.h"
#include "mode2/TablePages.h"
#include "mode1/tableAttributeDlg.h"
#include "mode1/tableRelationDlg.h"
*/

Arrow::Arrow(QGraphicsItem * parent) : QGraphicsLineItem(parent)
{
	this->startTable = 0;
	this->setFlag(QGraphicsItem::ItemIsSelectable, true);
	this->endTable = 0;
	this->setPen(QPen(Qt::black, 2, Qt::SolidLine, Qt::RoundCap, Qt::RoundJoin));
}

Arrow::Arrow(Table* startTable, Table* endTable, int mode, QGraphicsItem *parent) : QGraphicsLineItem(parent)
{
	this->startTable = startTable;
	this->setFlag(QGraphicsItem::ItemIsSelectable, true);
	this->endTable = endTable;
	this->mode = mode;
	//QString buffer1;
	//QString buffer2;
	int color=0;

	if( this->mode == 1 ){
		this->startTableCardinality = 1;
		startCardi = QString("1");
		this->endTableCardinality = 1;
		endCardi = QString("0...1");
		color = Qt::darkGreen;
	}
	else if( this->mode == 2 ){
		this->startTableCardinality = 3;
		startCardi = QString("*");
		this->endTableCardinality = 2;
		endCardi = QString("1...*");
		color = Qt::red;
	}
	else if( this->mode == 3 ){
		this->startTableCardinality = 2;
		startCardi = QString("0");
		this->endTableCardinality = 1;
		endCardi = QString("0...*");
		color = Qt::magenta;
	}
	
	//QPen pen(color);
	//this->startCardinality->setBrush(pen);
	this->startCardinality = new QGraphicsTextItem(startCardi, this);
	//this->endCardinality->setPen(pen);
	this->endCardinality = new QGraphicsTextItem(endCardi, this);

	this->SetPosCardi();	
}

QRectF Arrow::boundingRect() const
{
    qreal extra = (pen().width() + 20) / 2.0;

    return QRectF(line().p1(), QSizeF(line().p2().x() - line().p1().x(), line().p2().y() - line().p1().y()))
        .normalized()
        .adjusted(-extra, -extra, extra, extra);
}

QPainterPath Arrow::shape() const
{
    QPainterPath path = QGraphicsLineItem::shape();
    path.addPolygon(this->head);

	path.addText(startCardinalityPoint, QFont(), endCardi);
	path.addText(endCardinalityPoint, QFont(), startCardi);

    return path;
}

void Arrow::updatePosition()
{
	//qDebug() << this;
	double centerX = this->startTable->pos().x() + this->startTable->boundingRect().width() / 2;
	double centerY = this->startTable->pos().y() + this->startTable->boundingRect().height() / 2;

	//  ̺  ǥ
	QPointF startTableCenterPoint(centerX, centerY);

	centerX = this->endTable->pos().x() + this->endTable->boundingRect().width() / 2;
	centerY = this->endTable->pos().y() + this->endTable->boundingRect().height() / 2;


	//  ̺  ǥ
	QPointF endTableCenterPoint(centerX, centerY);

	QLineF line(startTableCenterPoint, endTableCenterPoint);
	//this->startCardi.clear();
	//this->endCardi.clear();

	//  ̺ ߽ ǥ ϴ ... 
    setLine(line);

	this->SetPosCardi();
}


void Arrow::SetCardinality(int endTableCardinality)
{
	this->endTableCardinality = endTableCardinality;
}

void Arrow::paint(QPainter *painter, const QStyleOptionGraphicsItem *, QWidget *)
{
	qreal Pi = 3.14;

    if (startTable->collidesWithItem(endTable)){
        return;
	}
	
    QPen pen = this->pen();
	qreal arrowSize = 10;
	
	if( this->mode == 1 ){
		pen.setColor(Qt::darkGreen);
		painter->setPen(pen);
		painter->setBrush(QColor(Qt::darkGreen));
	}
	else if( this->mode == 2 ){
		pen.setColor(Qt::red);
		painter->setPen(pen);
		painter->setBrush(QColor(Qt::red));
	}
	else if( this->mode == 3 ){
		pen.setColor(Qt::magenta);
		painter->setPen(pen);
		painter->setBrush(QColor(Qt::magenta));
	}

	double centerX = this->startTable->pos().x() + this->startTable->boundingRect().width() / 2;
	double centerY = this->startTable->pos().y() + this->startTable->boundingRect().height() / 2;

	//  ̺  ǥ
	QPointF startTableCenterPoint(centerX, centerY);

	centerX = this->endTable->pos().x() + this->endTable->boundingRect().width() / 2;
	centerY = this->endTable->pos().y() + this->endTable->boundingRect().height() / 2;

	//  ̺  ǥ
	QPointF endTableCenterPoint(centerX, centerY);
	
	//  ̺  ϴ ...
    QLineF centerLine(startTableCenterPoint, endTableCenterPoint);

    //QPolygonF endPolygon = endTable->polygon();
    QPointF p1 = QPointF(endTable->pos().x(), endTable->pos().y());

	//   ǥ ( : », , , )
    QPointF p2[4] = { QPointF(0,0), };
    QPointF intersectPoint;
    QLineF polyLine;
	QPoint buffer;

	p2[0] = QPointF(endTable->pos().x() + endTable->boundingRect().width(), endTable->pos().y());
	p2[1] = QPointF(endTable->pos().x() + endTable->boundingRect().width(), 
						endTable->pos().y() + endTable->boundingRect().height());
	p2[2] = QPointF(endTable->pos().x(), endTable->pos().y() + endTable->boundingRect().height());
	p2[3] = QPointF(endTable->pos().x(), endTable->pos().y());
	
	for(int i=0; i < 4; i++){
		polyLine = QLineF(p1, p2[i]);
		QLineF::IntersectType intersectType = polyLine.intersect(centerLine, &intersectPoint);
		if (intersectType == QLineF::BoundedIntersection){
			break;
		}
		p1 = p2[i];
	}

    setLine(QLineF(intersectPoint, startTableCenterPoint));

	// ȭǥ ﰢ ׸ κ....
    double angle = ::acos(line().dx() / this->line().length());

    if (line().dy() >= 0){
        angle = (Pi * 2) - angle;
	}
	
	QPointF arrowP1 = line().p1() + QPointF(sin(angle + Pi / 3) * arrowSize, cos(angle + Pi / 3) * arrowSize);
	QPointF arrowP2 = line().p1() + QPointF(sin(angle + Pi - Pi / 3) * arrowSize, cos(angle + Pi - Pi / 3) * arrowSize);
	
	this->head.clear();
	this->head << line().p1() << arrowP1 << arrowP2;
	painter->drawLine(line());
	painter->drawPolygon(this->head);

	//DrawCardinality(painter, intersectPoint, startTableCenterPoint, centerLine);
	if( this->startTableCardinality == 1 ){
		startCardi = QString("1");
	}
	else if( this->startTableCardinality == 2 ){
		startCardi = QString("0");
	}
	else if( this->startTableCardinality == 3 ){
		startCardi = QString("*");
	}

	if( this->endTableCardinality == 1 ){
		endCardi = QString("0...*");
	}
	else if( this->endTableCardinality == 2 ){
		endCardi = QString("1...*");
	}
	else if( this->endTableCardinality == 3 ){
		endCardi = QString("0...1");
	}

	this->SetPosCardi();

	if (isSelected()) {
		painter->setPen(QPen(QColor(Qt::black), 1, Qt::DashLine));
        QLineF myLine = line();
        myLine.translate(0, 4.0);
        painter->drawLine(myLine);
        myLine.translate(0,-8.0);
        painter->drawLine(myLine);
    }
}

void Arrow::DrawCardinality(QPainter *painter, QPointF& intersectPoint, QPointF& startTableCenterPoint, QLineF& centerLine)
{
	//this->startCardi=QString("dddd");
	//this->endCardi=QString("cccc");

	painter->drawText(endCardinalityPoint, startCardi);
	painter->drawText(startCardinalityPoint, endCardi);


	//painter->drawText(endCardinalityPoint, startCardi);
	//painter->drawText(startCardinalityPoint, endCardi);
	
	if( this->startTableCardinality == 1 ){
		startCardi = QString("1");
	}
	else if( this->startTableCardinality == 2 ){
		startCardi = QString("0");
	}
	else if( this->startTableCardinality == 3 ){
		startCardi = QString("*");
	}

	if( this->endTableCardinality == 1 ){
		endCardi = QString("0...*");
	}
	else if( this->endTableCardinality == 2 ){
		endCardi = QString("1...*");
	}
	else if( this->endTableCardinality == 3 ){
		endCardi = QString("0...1");
	}

	//  ̺ ἱ  ã κ...
    QPointF p2[4] = { QPointF(0,0), };
    QPointF intersectPointS;
    QLineF polyLine;
	QPoint buffer;
	QPointF p1 = QPointF(startTable->pos().x(), startTable->pos().y());

	p2[0] = QPointF(startTable->pos().x() + startTable->boundingRect().width(), startTable->pos().y());
	p2[1] = QPointF(startTable->pos().x() + startTable->boundingRect().width(), 
						startTable->pos().y() + startTable->boundingRect().height());
	p2[2] = QPointF(startTable->pos().x(), startTable->pos().y() + startTable->boundingRect().height());
	p2[3] = QPointF(startTable->pos().x(), startTable->pos().y());
	
	for(int i=0; i < 4; i++){
		polyLine = QLineF(p1, p2[i]);
		QLineF::IntersectType intersectType = polyLine.intersect(centerLine, &intersectPointS);
		if (intersectType == QLineF::BoundedIntersection){
			break;
		}
		p1 = p2[i];
	}

	double startX = intersectPoint.x();
	double startY = intersectPoint.y();

	if( intersectPoint.x() > intersectPointS.x() ){
		startX -= 20;
	}

	else{
		startX += 20;
	}
	if( intersectPoint.y() > intersectPointS.y() ){
		startY -= 20;
	}

	else{
		startY += 20;
	}
	
	startCardinalityPoint = QPointF(startX, startY);

	double endX = intersectPointS.x();
	double endY = intersectPointS.y();

	if( intersectPointS.x() > intersectPoint.x() ){
		endX -= 10;
	}

	else{
		endX += 10;
	}
	if( intersectPointS.y() > intersectPoint.y() ){
		endY -= 10;
	}

	else{
		endY += 10;
	}
	
	endCardinalityPoint = QPointF(endX, endY);

	//this->startCardi=QString("dddd");
	//this->endCardi=QString("cccc");

	painter->drawText(endCardinalityPoint, startCardi);
	painter->drawText(startCardinalityPoint, endCardi);
}

bool Arrow::operator ==(Arrow* other)
{
	bool ret = false;

	if( (this->startTable->pos() == other->GetStartTable()->pos())
			&& (this->endTable->pos() == other->GetEndTable()->pos()) ){
		ret = true;
	}

	return ret;
}

void Arrow::mouseDoubleClickEvent ( QGraphicsSceneMouseEvent * event )
{
	SHtableRelationDlg* tableRelationDialog = new SHtableRelationDlg(this);
	//this->scene()->clearSelection();
	tableRelationDialog->exec();
}

Arrow::~Arrow()
{
}

void Arrow::SetPosCardi()
{
	double centerX = this->startTable->pos().x() + this->startTable->boundingRect().width() / 2;
	double centerY = this->startTable->pos().y() + this->startTable->boundingRect().height() / 2;

	//  ̺  ǥ
	QPointF startTableCenterPoint(centerX, centerY);

	centerX = this->endTable->pos().x() + this->endTable->boundingRect().width() / 2;
	centerY = this->endTable->pos().y() + this->endTable->boundingRect().height() / 2;

	//  ̺  ǥ
	QPointF endTableCenterPoint(centerX, centerY);
	
	//  ̺  ϴ ...
    QLineF centerLine(startTableCenterPoint, endTableCenterPoint);

    //QPolygonF endPolygon = endTable->polygon();
    QPointF p1 = QPointF(endTable->pos().x(), endTable->pos().y());

	//   ǥ ( : », , , )
    QPointF p2[4] = { QPointF(0,0), };
    QPointF intersectPoint;
    QLineF polyLine;
	QPoint buffer;

	p2[0] = QPointF(endTable->pos().x() + endTable->boundingRect().width(), endTable->pos().y());
	p2[1] = QPointF(endTable->pos().x() + endTable->boundingRect().width(), 
						endTable->pos().y() + endTable->boundingRect().height());
	p2[2] = QPointF(endTable->pos().x(), endTable->pos().y() + endTable->boundingRect().height());
	p2[3] = QPointF(endTable->pos().x(), endTable->pos().y());
	
	for(int i=0; i < 4; i++){
		polyLine = QLineF(p1, p2[i]);
		QLineF::IntersectType intersectType = polyLine.intersect(centerLine, &intersectPoint);
		if (intersectType == QLineF::BoundedIntersection){
			break;
		}
		p1 = p2[i];
	}

	//  ̺ ἱ  ã κ...
    QPointF p4[4] = { QPointF(0,0), };
    QPointF intersectPointS;
    //QLineF polyLine;
	//QPoint buffer;
	QPointF p3 = QPointF(startTable->pos().x(), startTable->pos().y());

	p4[0] = QPointF(startTable->pos().x() + startTable->boundingRect().width(), startTable->pos().y());
	p4[1] = QPointF(startTable->pos().x() + startTable->boundingRect().width(), 
						startTable->pos().y() + startTable->boundingRect().height());
	p4[2] = QPointF(startTable->pos().x(), startTable->pos().y() + startTable->boundingRect().height());
	p4[3] = QPointF(startTable->pos().x(), startTable->pos().y());
	
	for(int i=0; i < 4; i++){
		polyLine = QLineF(p3, p4[i]);
		QLineF::IntersectType intersectType = polyLine.intersect(centerLine, &intersectPointS);
		if (intersectType == QLineF::BoundedIntersection){
			break;
		}
		p3 = p4[i];
	}

	double startX = intersectPoint.x();
	double startY = intersectPoint.y();

	if( intersectPoint.x() > intersectPointS.x() ){
		startX -= 40;
	}

	else{
		startX += 40;
	}
	if( intersectPoint.y() > intersectPointS.y() ){
		startY -= 20;
	}

	else{
		startY += 20;
	}
	
	startCardinalityPoint = QPointF(startX, startY);

	double endX = intersectPointS.x();
	double endY = intersectPointS.y();

	if( intersectPointS.x() > intersectPoint.x() ){
		endX -= 40;
	}

	else{
		endX += 40;
	}
	if( intersectPointS.y() > intersectPoint.y() ){
		endY -= 20;
	}

	else{
		endY += 20;
	}
	
	endCardinalityPoint = QPointF(endX, endY);

	this->startCardinality->setPlainText(endCardi);
	this->endCardinality->setPlainText(startCardi);

	this->startCardinality->setPos(startCardinalityPoint);
	this->endCardinality->setPos(endCardinalityPoint);
}
